﻿
# Fail the build on error
$ErrorActionPreference = 'Stop'

# Default the exit code to something greater than 0 
# If the deployment is successful this will be set to one to indicate a successful build
$LastExitCode = 1

Write-Output "`$env:SESSIONNAME" $env:SESSIONNAME

# Jenkins specific parameters
if ($env:WORKSPACE -eq $null -or $env:WORKSPACE -eq '')
{
    Write-Error "Jenkins build parameter:`$env:WORKSPACE is missing"
}

if ($env:CRM_ADMIN_USERNAME -eq $null -or $env:CRM_ADMIN_USERNAME -eq '')
{
    Write-Error "Jenkins build parameter:`$env:CRM_ADMIN_USERNAME is missing"
}

if ($env:CRM_ADMIN_PASSWORD -eq $null -or $env:CRM_ADMIN_PASSWORD -eq '')
{
    Write-Error "Jenkins build parameter:`$env:CRM_ADMIN_PASSWORD is missing"
}

if ($env:CRM_ORGANIZATION_NAME -eq $null -or $env:CRM_ORGANIZATION_NAME -eq '')
{
    Write-Error "Jenkins build parameter:`$env:CRM_ORGANIZATION_NAME is missing"
}

if ($env:CRM_URL -eq $null -or $env:CRM_URL -eq '')
{
    Write-Error "Jenkins build parameter:`$env:CRM_URL is missing"
}


# Variables for the data and solution package
$packagePath = $env:WORKSPACE + '\Configuration\Release'
$unpackedPackagePath = $env:WORKSPACE + '\UnpackedPackage'

# Path to the Xrm PowerShell Scripts for the Package Deployer
$packageDeployerPSPath = $env:WORKSPACE + '\SDK\Tools\PackageDeployer\PowerShell'

# Register the Xrm Tooling CmdLets
cd $packageDeployerPSPath
.\RegisterXRMTooling.ps1
Add-PSSnapin Microsoft.Xrm.Tooling.Connector
Add-PSSnapin Microsoft.Xrm.Tooling.PackageDeployment

# Script parameters #
$organizationName = $env:CRM_ORGANIZATION_NAME
$serverUrl =  $env:CRM_URL

$crmAdminUser = $env:CRM_ADMIN_USERNAME
$crmAdminPassword = ConvertTo-SecureString -String $env:CRM_ADMIN_PASSWORD -AsPlainText -Force

$ScriptStart = (Get-Date)
Write-Host "Deployment script started: "  $ScriptStart
Write-Output "Connecting to Dynamics CRM Org:$env:CRM_ORGANIZATION_NAME"
$crmCred = New-Object System.Management.Automation.PSCredential ($crmAdminUser,$crmAdminPassword) 


# Refer to https://msdn.microsoft.com/en-us/library/dn756303.aspx for more detail 
$conn = Get-CrmConnection -OrganizationName $organizationName -ServerUrl $serverUrl -Credential $crmCred -ErrorAction Stop
Write-Host "Connected to Org" $conn.ConnectedOrgFriendlyName 
Get-CrmPackages –PackageDirectory $packagePath
Import-CrmPackage –CrmConnection $conn –PackageDirectory $packagePath –PackageName BTSSS.CRM.Deployment.dll –UnpackFilesDirectory $unpackedPackagePath -Verbose -WhatIf

# Notify Jenkins the deployment was successful
$LastExitCode = 0




